/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.autoplot.ScriptContext;
import org.autoplot.dom.Application;
import org.autoplot.jythonsupport.JythonUtil;
import org.autoplot.jythonsupport.SimplifyScriptSupport;
import org.das2.components.DasProgressPanel;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.jythoncompletion.CompletionContext;
import org.das2.jythoncompletion.CompletionSupport;
import org.das2.jythoncompletion.JythonCompletionTask;
import org.das2.jythoncompletion.ui.CompletionImpl;
import org.das2.jythoncompletion.ui.CompletionResultSetImpl;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.filesystem.FileSystem;
import org.python.core.PyException;
import org.python.util.InteractiveInterpreter;

public class Test038 {
    static final Logger logger = Logger.getLogger("autoplot");
    public static final int COMPLETION_ERROR = -99;
    public static final int MAX_COMPLETION_COUNT = 77;

    private static int doTests(String testId, String file) {
        int t1 = Test038.doTestsGetParams(testId, file);
        int t2 = Test038.doTestsGetCompletions(testId, file);
        int t3 = Test038.doTestsCountCompletions(testId, file);
        return t1 != 0 ? t1 : (t2 != 0 ? t2 : t3);
    }

    private static int doTestsGetCompletions(String testId, String file) {
        long t0 = System.currentTimeMillis();
        System.err.println("== test " + testId + ": " + file + " ==");
        try {
            String script = JythonUtil.readScript((Reader)new FileReader(file));
            String scrip = SimplifyScriptSupport.simplifyScriptToCompletions((String)script);
            File f = new File(file);
            String fout = "./test038_completions_" + f.getName();
            try (FileWriter fw = new FileWriter(fout);){
                fw.append(scrip);
            }
            List parms = JythonUtil.getGetParams((String)script);
            parms.forEach(p -> System.err.println(p));
            System.err.println(String.format("read params in %d millis: %s\n", System.currentTimeMillis() - t0, file));
            return 0;
        }
        catch (IOException | PyException ex) {
            ex.printStackTrace();
            System.err.println(String.format("*** failed within %d millis: %s\n", System.currentTimeMillis() - t0, file));
            return 1;
        }
    }

    public static QDataSet getCompletionsCount(String ss, int[] positions) {
        JTextArea tc = new JTextArea();
        tc.setText(ss);
        JDialog d = new JDialog();
        d.getContentPane().add(tc);
        d.pack();
        d.setVisible(true);
        JythonCompletionTask jct = new JythonCompletionTask((JTextComponent)tc);
        CompletionResultSetImpl rs = CompletionImpl.get().createTestResultSet(null, 0);
        DasProgressPanel mon = DasProgressPanel.createFramed((String)"checking completions");
        DataSetBuilder dsb = new DataSetBuilder(2, 100, 3);
        for (int i = 0; i < positions.length; ++i) {
            CompletionContext cc;
            int irow = -99;
            int icol = -99;
            try {
                int i0;
                int ip = positions[i];
                if (mon.isCancelled()) break;
                tc.setCaretPosition(ip);
                try {
                    irow = tc.getLineOfOffset(ip);
                    i0 = tc.getLineStartOffset(irow);
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(Test038.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
                icol = ip - i0;
                cc = CompletionSupport.getCompletionContext((JTextComponent)tc);
                if (cc == null) continue;
                int count = jct.doQuery(cc, rs.getResultSet());
                dsb.nextRecord(new Object[]{irow + 1, icol, count});
                continue;
            }
            catch (RuntimeException | BadLocationException e) {
                e.printStackTrace();
                try {
                    cc = CompletionSupport.getCompletionContext((JTextComponent)tc);
                    jct.doQuery(cc, rs.getResultSet());
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(Test038.class.getName()).log(Level.SEVERE, null, ex);
                }
                dsb.nextRecord(new Object[]{irow + 1, icol, -99});
            }
        }
        d.setVisible(false);
        d.dispose();
        return dsb.getDataSet();
    }

    private static int doTestsCountCompletions(String testId, String file) {
        long t0 = System.currentTimeMillis();
        System.err.println("== test " + testId + ": " + file + " ==");
        FileSystem.settings().setOffline(true);
        try {
            String script = JythonUtil.readScript((Reader)new FileReader(file));
            File f = new File(file);
            int n = script.length();
            int[] positions = new int[Math.min(100, n)];
            for (int i = 0; i < positions.length; ++i) {
                positions[i] = script.length() * i / positions.length;
            }
            QDataSet rr = Test038.getCompletionsCount(script, positions);
            QDataSet line = Ops.slice1((QDataSet)rr, (int)0);
            QDataSet column = Ops.slice1((QDataSet)rr, (int)1);
            QDataSet count = Ops.slice1((QDataSet)rr, (int)2);
            QDataSet positionsds = Ops.dataset((Object)positions).trim(0, count.length());
            ScriptContext.formatDataSet(line, "test038." + f.getName() + ".cdf?linenum");
            ScriptContext.formatDataSet(column, "test038." + f.getName() + ".cdf?column&append=T");
            ScriptContext.formatDataSet(count, "test038." + f.getName() + ".cdf?count&append=T");
            ScriptContext.formatDataSet(positionsds, "test038." + f.getName() + ".cdf?position&append=T");
            ScriptContext.plot(Ops.slice1((QDataSet)rr, (int)0), Ops.slice1((QDataSet)rr, (int)1), Ops.lesserOf((Object)Ops.slice1((QDataSet)rr, (int)2), (Object)77));
            QDataSet r = Ops.where((QDataSet)Ops.eq((Object)count, (Object)-99));
            if (r.length() > 0) {
                Application dom = ScriptContext.getDocumentModel();
                int i = (int)r.value(0);
                String s = String.format("Fail @ %d<br>line=%d col=%d", positions[i], (int)line.value(i), (int)column.value(i));
                dom.getController().addAnnotation(dom.getPlots(0), s);
            }
            ScriptContext.waitUntilIdle();
            ScriptContext.setRenderStyle("digital");
            ScriptContext.getDocumentModel().getPlotElements(0).setRenderControl("format=%d&fontSize=0.6em");
            ScriptContext.getDocumentModel().getPlots(0).getYaxis().setRange(DatumRange.newDatumRange((double)-1.0, (double)120.0, (Units)Units.dimensionless));
            ScriptContext.getDocumentModel().getPlots(0).getXaxis().setLog(false);
            ScriptContext.setTitle("completions count for " + f.getName());
            String fout = "test038_completions_" + f.getName() + ".png";
            ScriptContext.writeToPng(fout);
            return r.length();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(String.format("*** failed within %d millis: %s\n", System.currentTimeMillis() - t0, file));
            return 1;
        }
    }

    private static int doTestsGetParams(String testId, String file) {
        long t0 = System.currentTimeMillis();
        System.err.println("== test " + testId + ": " + file + " ==");
        try {
            String script = JythonUtil.readScript((Reader)new FileReader(file));
            String scrip = JythonUtil.simplifyScriptToGetParams((String)script, (boolean)true);
            File f = new File(file);
            String fout = "./test038_params_" + f.getName();
            try (FileWriter fw = new FileWriter(fout);){
                fw.append(scrip);
            }
            List parms = JythonUtil.getGetParams((String)script);
            parms.forEach(p -> System.err.println(p));
            System.err.println(String.format("read params in %d millis: %s\n", System.currentTimeMillis() - t0, file));
            return 0;
        }
        catch (IOException | PyException ex) {
            ex.printStackTrace();
            System.err.println(String.format("*** failed within %d millis: %s\n", System.currentTimeMillis() - t0, file));
            return 1;
        }
    }

    public static int doTestMany(String f) {
        System.err.println("Reading tests from file: " + f);
        int t = 0;
        try (BufferedReader in = new BufferedReader(new FileReader(f));){
            String[] ss;
            String s = in.readLine();
            int i = s.indexOf("#");
            if (i > 0) {
                s = s.substring(0, i);
            }
            if ((ss = (s = s.trim()).split(" ", -2)).length == 2) {
                t = Math.max(t, Test038.doTests(ss[0], ss[1]));
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Test038.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Test038.class.getName()).log(Level.SEVERE, null, ex);
        }
        return t;
    }

    public static int testGetParams() {
        int t = 0;
        t = Math.max(t, Test038.doTests("112", "/home/jbf/ct/hudson/script/test038/windlistener.jy"));
        t = Math.max(t, Test038.doTests("009", "/home/jbf/ct/hudson/script/test038/jydsCommentBug.jyds"));
        t = Math.max(t, Test038.doTests("010", "/home/jbf/ct/hudson/script/test038/addPointDigitizer.jy"));
        t = Math.max(t, Test038.doTests("002", "/home/jbf/ct/hudson/script/test038/demoParms1.jy"));
        t = Math.max(t, Test038.doTests("008", "/home/jbf/ct/hudson/script/test038/jedi_l3_valid_tofxe_events.jyds"));
        t = Math.max(t, Test038.doTests("000", "/home/jbf/ct/hudson/script/test038/trivial.jy"));
        t = Math.max(t, Test038.doTests("001", "/home/jbf/ct/hudson/script/test038/demoParms0.jy"));
        t = Math.max(t, Test038.doTests("002", "/home/jbf/ct/hudson/script/test038/demoParms1.jy"));
        t = Math.max(t, Test038.doTests("003", "/home/jbf/ct/hudson/script/test038/demoParms.jy"));
        t = Math.max(t, Test038.doTests("004", "/home/jbf/ct/hudson/script/test038/rbsp/emfisis/background_removal_wfr.jyds"));
        t = Math.max(t, Test038.doTests("005", "/home/jbf/ct/hudson/script/test038/demoParms2.jy"));
        t = Math.max(t, Test038.doTests("006", "/home/jbf/ct/hudson/script/test038/fce_A.jyds"));
        t = Math.max(t, Test038.doTests("007", "/home/jbf/ct/hudson/script/test038/fce_A_2.jyds"));
        t = Math.max(t, Test038.doTests("110", "/home/jbf/ct/hudson/script/test038/addPointDigitizer.jy"));
        t = Math.max(t, Test038.doTests("111", "/home/jbf/ct/hudson/script/test038/rewriteF_L0.jy"));
        t = Math.max(t, Test038.doTestMany("/home/jbf/ct/hudson/script/test038/test038.txt"));
        return t;
    }

    public static void main(String[] args) throws IOException {
        Test038.doTests("002", "/home/jbf/ct/hudson/script/test038/demoParms1.jy");
        long t0 = System.currentTimeMillis();
        InteractiveInterpreter interp = JythonUtil.createInterpreter((boolean)true);
        interp.eval("1+2");
        System.err.println(String.format("== first initialize in %d millis\n", System.currentTimeMillis() - t0));
        int t = Test038.testGetParams();
        if (t != 0) {
            throw new IllegalStateException("at least one of the tests failed.");
        }
        System.err.println("ALL OKAY!");
        System.exit(0);
    }
}

